/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import com.ibm.hwmca.base.time.CustConDateTimeBeanData;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CustConDateTimeBean
extends PanelBean {
    private static final String TRACE_MASKT = "XTODCOBT";
    private static final String TRACE_MASKF = "XTODCOBF";
    private static final String TRACE_MASKD = "XTODCOBD";
    private CustConDateTimeBeanData beanData;
    private String m_sClockChoice;
    private ValueDescriptor[] m_vdClockChoice;
    public static final String CLOCK_TIME_UTC = "UTC";
    public static final String CLOCK_TIME_LOCAL = "Local";
    public static final String CLOCK_CHOICE = "ClockChoice";
    public static final String TIME_NUMBER = "TimeEdit";
    public static final String DATE_NUMBER = "DateEdit";
    public static final String TIME_ZONE_CHOICE = "TimeZoneChoice";
    public static final String TZ_SEPARATOR = ",";
    public static final String CLOCK_TIME_GMT = "GMT";
    public static final String CUSTOMIZE_BUTTON = "CustomizeButton";
    public static final String REFRESH_BUTTON = "RefreshButton";
    public static final String CANCEL_COMMAND = "CANCEL";
    public static final String TASKLET_EVENT = "Event";
    public static final String DISPLAY_MESSAGE = "DisplayMessage";
    public static final String DISPLAY_INVALID_DATE = "InvalidDate";
    public static final String DISPLAY_INVALID_TIME = "InvalidTime";
    public static final String DISPLAY_SUBSTVAR = "SubstitutionVar";
    private String m_sTimeEdit;
    private String m_sDateEdit;
    private String m_sTimeZoneChoice;
    private String beanTimeZoneChoice;
    private ValueDescriptor[] m_vdTimeZoneChoice;
    private Calendar dateTime;
    private boolean canceled = false;
    private boolean bLoadMethod = false;

    public CustConDateTimeBean(CustConDateTimeBeanData data) {
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean ctor(" + data + ")");
        this.beanData = data;
        this.load();
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean ctor");
    }

    public ValueDescriptor[] getClockChoiceList() {
        return this.m_vdClockChoice;
    }

    public void setClockChoice(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.setClockChoice(" + s + ")");
        if (!s.equals(this.m_sClockChoice)) {
            String oldClockChoice = this.m_sClockChoice;
            this.m_sClockChoice = s;
            this.userTaskManager.storeAllElements();
            try {
                this.adjustTimeZone();
            }
            catch (IllegalUserDataException iude) {
                Trace.trace(TRACE_MASKF, "   IllegalUserDataException caught - restoring clock choice.");
                this.m_sClockChoice = oldClockChoice;
                this.userTaskManager.refreshElement(this.getMountPrefix() + CLOCK_CHOICE);
                throw iude;
            }
            this.userTaskManager.refreshElement(this.getMountPrefix() + DATE_NUMBER);
            this.userTaskManager.refreshElement(this.getMountPrefix() + TIME_NUMBER);
        }
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.setClockChoice(" + s + ")");
    }

    public String getClockChoice() {
        return this.m_sClockChoice;
    }

    public String getTimeEdit() {
        return this.m_sTimeEdit;
    }

    public void setTimeEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.setTimeEdit(" + s + ")");
        this.parseTime(s.trim(), this.dateTime.getTimeZone());
        this.m_sTimeEdit = s.trim();
        Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.setTimeEdit(" + s + ")");
    }

    public String getDateEdit() {
        return this.m_sDateEdit;
    }

    public void setDateEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.setDateEdit(" + s + ")");
        this.parseDate(s.trim(), this.dateTime.getTimeZone());
        this.m_sDateEdit = s.trim();
        Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.setDateEdit(" + s + ")");
    }

    public ValueDescriptor[] getTimeZoneChoiceList() {
        return this.m_vdTimeZoneChoice;
    }

    public void setTimeZoneChoice(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.setTimeZoneChoice(" + s + ")");
        if (!s.equals(this.m_sTimeZoneChoice)) {
            String oldTimeZone = this.m_sTimeZoneChoice;
            this.m_sTimeZoneChoice = s;
            this.userTaskManager.storeAllElements();
            try {
                this.adjustTimeZone();
            }
            catch (IllegalUserDataException iude) {
                Trace.trace(TRACE_MASKF, "   IllegalUserDataException caught - restoring clock choice.");
                this.m_sTimeZoneChoice = oldTimeZone;
                this.userTaskManager.refreshElement(this.getMountPrefix() + TIME_ZONE_CHOICE);
                throw iude;
            }
            this.userTaskManager.refreshElement(this.getMountPrefix() + DATE_NUMBER);
            this.userTaskManager.refreshElement(this.getMountPrefix() + TIME_NUMBER);
        }
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.setTimeZoneChoice(" + s + ")");
    }

    public String getTimeZoneChoice() {
        return this.m_sTimeZoneChoice;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalArgumentException {
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.verifyChanges()");
        this.dateTime.setTime(this.parseDateTime(this.m_sDateEdit, this.m_sTimeEdit, this.dateTime.getTimeZone()));
        Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.verifyChanges()");
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean.load()");
        if (!this.bLoadMethod) {
            this.bLoadMethod = true;
            String[] tzl = this.beanData.getTimeZoneList();
            this.m_vdTimeZoneChoice = new ValueDescriptor[tzl.length];
            for (int i = 0; i < tzl.length; ++i) {
                this.m_vdTimeZoneChoice[i] = this.convert(tzl[i]);
                if (i >= 10) continue;
                Trace.trace(TRACE_MASKF, "   tzl[" + i + "] -> title = [" + this.m_vdTimeZoneChoice[i].getTitle() + "], name = [" + this.m_vdTimeZoneChoice[i].getName() + "]");
            }
            this.m_sClockChoice = this.beanData.getClockChoice();
            this.m_vdClockChoice = new ValueDescriptor[0];
            this.m_sTimeZoneChoice = this.translateTimeZone(this.beanData.getTimeZoneChoice(), this.beanData.getTimeZoneList());
            Trace.trace(TRACE_MASKT, "   m_sTimeZoneChoice = " + this.m_sTimeZoneChoice);
            this.dateTime = Calendar.getInstance();
            this.dateTime.setTimeZone(this.beanData.getDateTimeNumber().getTimeZone());
            this.dateTime.setTime(this.beanData.getDateTimeNumber().getTime());
            try {
                this.adjustTimeZone();
            }
            catch (IllegalUserDataException iude) {
                Trace.trace(TRACE_MASKT, "   IllegalUserDataException caught:" + (Object)((Object)iude));
            }
            this.bLoadMethod = false;
        }
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.load()");
    }

    public void panelAction(TaskActionEvent event) {
        String command = event.getActionCommand();
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean.panelAction() for command = " + command);
        if (command.equals(CANCEL_COMMAND)) {
            Trace.trace(TRACE_MASKF, "   CANCEL was submitted.");
            this.canceled = true;
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData(TASKLET_EVENT, event);
            this.postTaskletRequest(request);
        } else if (command.equals(CUSTOMIZE_BUTTON)) {
            this.userTaskManager.storeAllElements();
            Trace.trace(TRACE_MASKF, "   CustomizeButton was submitted.");
            try {
                this.parseDate(this.m_sDateEdit, this.dateTime.getTimeZone());
                this.parseTime(this.m_sTimeEdit, this.dateTime.getTimeZone());
                this.verifyChanges();
                Trace.trace(TRACE_MASKF, "   Updated bean=" + this);
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData(TASKLET_EVENT, event);
                CustConDateTimeBeanData newBeanData = new CustConDateTimeBeanData(this.m_sClockChoice, this.dateTime, this.beanData.getTimeZoneList(), this.untranslateTimeZone(this.m_sTimeZoneChoice, this.beanData.getTimeZoneList()));
                request.setData("beanData", newBeanData);
                this.userTaskManager.refreshAllElements();
                Trace.trace(TRACE_MASKF, "   About to send new beanData: " + newBeanData);
                this.postTaskletRequest(request);
            }
            catch (IllegalUserDataException iude) {
                Trace.trace(TRACE_MASKF, "   Date or time could not be parsed.");
            }
        } else if (command.equals(REFRESH_BUTTON)) {
            Trace.trace(TRACE_MASKF, "   RefreshButton was submitted.");
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData(TASKLET_EVENT, event);
            this.postTaskletRequest(request);
        } else {
            Trace.trace(TRACE_MASKF, "   Unrecognized action command: " + command);
        }
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.panelAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean.update()");
        if (this.canceled) {
            Trace.trace(TRACE_MASKF, "   Ignoring update request due to previous cancel command");
        } else {
            this.beanData = (CustConDateTimeBeanData)newData;
            this.load();
            Trace.trace(TRACE_MASKF, "   About to refreshAllElements(); bean=" + this.toString());
            this.userTaskManager.refreshAllElements();
        }
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.update()");
    }

    public void adjustTimeZone() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.adjustTimeZone()");
        Trace.trace(TRACE_MASKF, "   Original time: " + this.toString());
        if (!this.bLoadMethod) {
            this.dateTime.setTime(this.parseDateTime(this.m_sDateEdit, this.m_sTimeEdit, this.dateTime.getTimeZone()));
        }
        TimeZone tz = Calendar.getInstance().getTimeZone();
        if (this.m_sClockChoice.equals(CLOCK_TIME_UTC)) {
            tz = TimeZone.getTimeZone(CLOCK_TIME_GMT);
        } else {
            String unxlatedTimeZone = this.untranslateTimeZone(this.m_sTimeZoneChoice, this.beanData.getTimeZoneList());
            if (unxlatedTimeZone != null && !unxlatedTimeZone.equals(this.m_vdTimeZoneChoice[0].getName())) {
                tz = TimeZone.getTimeZone(unxlatedTimeZone);
            }
        }
        Trace.trace(TRACE_MASKF, "   Clock Choice = " + this.m_sClockChoice + "   Time Zone Choice = " + this.m_sTimeZoneChoice);
        Trace.trace(TRACE_MASKF, "   Using TimeZone = " + tz);
        this.dateTime.setTimeZone(tz);
        this.m_sDateEdit = this.formatDate(this.dateTime);
        this.m_sTimeEdit = this.formatTime(this.dateTime);
        Trace.trace(TRACE_MASKF, "   Updated time: " + this.toString());
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.adjustTime()");
    }

    public String formatDate(Calendar c) {
        DateFormat df = DateFormat.getDateInstance();
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            df = DateFormat.getDateInstance(2, userContext.getLocale());
        }
        catch (NullContextException e) {
            df = DateFormat.getDateInstance();
        }
        df.setTimeZone(c.getTimeZone());
        return df.format(c.getTime());
    }

    public String formatTime(Calendar c) {
        DateFormat df = DateFormat.getTimeInstance();
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            df = DateFormat.getTimeInstance(2, userContext.getLocale());
        }
        catch (NullContextException e) {
            df = DateFormat.getTimeInstance();
        }
        df.setTimeZone(c.getTimeZone());
        return df.format(c.getTime());
    }

    public void parseDate(String s, TimeZone tz) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.parseDate(" + s + ")");
        DateFormat df = DateFormat.getDateInstance();
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            df = DateFormat.getDateInstance(2, userContext.getLocale());
        }
        catch (NullContextException e) {
            df = DateFormat.getDateInstance();
        }
        df.setTimeZone(tz);
        df.setLenient(false);
        try {
            Date newTime = df.parse(s);
        }
        catch (ParseException pe) {
            String errorMsg = new BaseMessageText("TIMEMSGDATE.TEXT", new Object[]{s}).toString();
            Trace.trace(TRACE_MASKF, "   ParseException caught: " + pe.toString());
            Trace.trace(TRACE_MASKF, "   errorMsg = [" + errorMsg + "]");
            Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.parseDate()");
            IllegalUserDataException iude = new IllegalUserDataException(errorMsg);
            throw iude;
        }
        Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.parseDate()");
    }

    public void parseTime(String s, TimeZone tz) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.parseTime(" + s + ")");
        DateFormat df = DateFormat.getTimeInstance();
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            df = DateFormat.getTimeInstance(2, userContext.getLocale());
        }
        catch (NullContextException e) {
            df = DateFormat.getTimeInstance();
        }
        df.setTimeZone(tz);
        df.setLenient(false);
        try {
            Date newTime = df.parse(s);
        }
        catch (ParseException pe) {
            String errorMsg = new BaseMessageText("TIMEMSGTIME.TEXT", new Object[]{s}).toString();
            Trace.trace(TRACE_MASKF, "   ParseException caught: " + pe.toString());
            Trace.trace(TRACE_MASKF, "   errorMsg = [" + errorMsg + "]");
            Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.parseTime()");
            IllegalUserDataException iude = new IllegalUserDataException(errorMsg);
            throw iude;
        }
        Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.parseTime()");
    }

    public Date parseDateTime(String d, String t, TimeZone tz) throws IllegalUserDataException {
        Date newTime;
        Trace.trace(TRACE_MASKF, "-> CustConDateTimeBean.parseDateTime()");
        this.parseDate(d, tz);
        this.parseTime(t, tz);
        DateFormat df = DateFormat.getDateTimeInstance();
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            df = DateFormat.getDateTimeInstance(2, 2, userContext.getLocale());
        }
        catch (NullContextException e) {
            df = DateFormat.getDateInstance();
        }
        df.setTimeZone(tz);
        df.setLenient(false);
        Trace.trace(TRACE_MASKF, "   parsing [" + d + "] and [" + t + "]");
        try {
            newTime = df.parse(d + " " + t);
        }
        catch (ParseException pe) {
            Trace.trace(TRACE_MASKF, "   ParseException caught: " + pe.toString());
            Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.parseDateTime()");
            IllegalUserDataException iude = new IllegalUserDataException(pe.toString());
            throw iude;
        }
        Trace.trace(TRACE_MASKF, "<- CustConDateTimeBean.parseDateTime()");
        return newTime;
    }

    public ValueDescriptor convert(String s) {
        int split = s.indexOf(TZ_SEPARATOR);
        return new ValueDescriptor(s.substring(split + 1), s.substring(0, split));
    }

    public String convert(ValueDescriptor vd) {
        return vd.getTitle() + TZ_SEPARATOR + vd.getName();
    }

    private String getTranslatedTimeZone(String s) {
        int split = s.indexOf(TZ_SEPARATOR);
        return s.substring(0, split);
    }

    private String getUntranslatedTimeZone(String s) {
        int split = s.indexOf(TZ_SEPARATOR);
        return s.substring(split + 1);
    }

    public String translateTimeZone(String s, String[] tzl) {
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean.translateTimeZone(" + s + ", tzl)");
        for (int i = 0; i < tzl.length; ++i) {
            if (!s.equals(this.getUntranslatedTimeZone(tzl[i]))) continue;
            return this.getTranslatedTimeZone(tzl[i]);
        }
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.translateTimeZone(" + s + ", tzl) returns null");
        return null;
    }

    public String untranslateTimeZone(String s, String[] tzl) {
        if (s != null) {
            for (int i = 0; i < tzl.length; ++i) {
                if (!s.equals(this.getTranslatedTimeZone(tzl[i]))) continue;
                return this.getUntranslatedTimeZone(tzl[i]);
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("clock choice=" + this.m_sClockChoice);
        sb.append("; date=" + this.formatDate(this.dateTime));
        sb.append("; time=" + this.formatTime(this.dateTime));
        sb.append("; TimeZone=" + this.m_sTimeZoneChoice);
        return sb.toString();
    }
}

